var samplePageObj = {
  // 샘플 타이틀
  title: 'attribute 포뮬러',
  subtitle: '조건에 따라 행이나 셀의 속성(Color, TexColor 등)을 동적으로 변경 할 수 있습니다.',
  // 샘플 설명
  desc: 'attribute+formula를 사용시에는 반드시 <strong>(Row)CalcOrder</strong>에 \'컬럼명+기능명\'형식으로, 계산 순서에 맞게 명시해 줘야합니다.<br>'
    + 'formula의 계산식은 문자열이나 함수형태로 설정할수 있습니다.'
    + 'ClassFormula 를 사용하려는 경우, css class 를 미리 지정해 두어야 합니다. ',

  // 객체 초기화 구문
  init: {
    Cfg: {
      ColorState: 0,
      SearchMode: 0,
      HeaderMerge: 3,
      DataMerge: 1,
    },
    Def: {
      Row: {
        CanFormula: 1,
        CalcOrder: 'D1Diff,D1Rate,D1DiffIcon,D1RateColor,D1RateTextColor,W1Diff,W1Rate,W1DiffIcon,W1RateColor,W1RateTextColor,M1Diff,M1Rate,M1DiffIcon,M1RateColor,M1RateTextColor,M3Diff,M3Rate,M3DiffIcon,M3RateColor,M3RateTextColor,M6Diff,M6Rate,M6DiffIcon,M6RateColor,M6RateTextColor,YTDDiff,YTDRate,YTDDiffIcon,YTDRateColor,YTDRateTextColor,Y1Diff,Y1Rate,Y1DiffIcon,Y1RateColor,Y1RateTextColor',
        FocusRow: "",
        HoverRow: "",
      },
      Col: {
      }
    },

    Cols: [
      {
        Header: ['국가','국가'],
        Type: 'Text',
        Name: 'Nation',
        Width: '70',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: ['지수','지수'],
        Type: 'Text',
        Name: 'IndexName',
        Width: '100',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: ['종가','종가'],
        Type: 'Float',
        Name: 'CP',
        Width: '100',
        Format: '#,##0.00',
      },
      {
        Header: ['전일','종가'],
        Type: 'Float',
        Name: 'D1',
        Width: '100',
        Format: '#,##0.00',
        Visible: 0,
        UserHidden: 1
      },
      {
        Header: ['전일','대비'],
        Type: 'Float',
        Name: 'D1Diff',
        Width: '80',
        Align: 'Right',
        Format:"#,##0.00",
        Formula: diffFormula,
        IconFormula: iconFormula
      },
      {
        Header: ['전일','등락율'],
        Type: 'Text',
        Name: 'D1Rate',
        Width: '80',
        Align: 'Right',
        Formula: rateFormula,
        ColorFormula: colorFormula,
        TextColorFormula: textColorFormula
      },
      {
        Header: ['Week','종가'],
        Type: 'Float',
        Name: 'W1',
        Width: '100',
        Format: '#,##0.00',
        Visible: 0,
        UserHidden: 1
      },
      {
        Header: ['Week','대비'],
        Type: 'Float',
        Name: 'W1Diff',
        Width: '80',
        Align: 'Right',
        Format:"#,##0.00",
        Formula: diffFormula,
        IconFormula: iconFormula
      },
      {
        Header: ['Week','등락율'],
        Type: 'Text',
        Name: 'W1Rate',
        Width: '80',
        Align: 'Right',
        Formula: rateFormula,
        ColorFormula: colorFormula,
        TextColorFormula: textColorFormula
      },
      {
        Header: ['Month','종가'],
        Type: 'Float',
        Name: 'M1',
        Width: '100',
        Format: '#,##0.00',
        Visible: 0,
        UserHidden: 1
      },
      {
        Header: ['Month','대비'],
        Type: 'Float',
        Name: 'M1Diff',
        Width: '90',
        Align: 'Right',
        Format:"#,##0.00",
        Formula: diffFormula,
        IconFormula: iconFormula
      },
      {
        Header: ['Month','등락율'],
        Type: 'Text',
        Name: 'M1Rate',
        Width: '90',
        Align: 'Right',
        Formula: rateFormula,
        ColorFormula: colorFormula,
        TextColorFormula: textColorFormula
      },
      {
        Header: ['3 Month','종가'],
        Type: 'Float',
        Name: 'M3',
        Width: '100',
        Format: '#,##0.00',
        Visible: 0,
        UserHidden: 1
      },
      {
        Header: ['3 Month','대비'],
        Type: 'Float',
        Name: 'M3Diff',
        Width: '90',
        Align: 'Right',
        Format:"#,##0.00",
        Formula: diffFormula,
        IconFormula: iconFormula
      },
      {
        Header: ['3 Month','등락율'],
        Type: 'Text',
        Name: 'M3Rate',
        Width: '90',
        Align: 'Right',
        Formula: rateFormula,
        ColorFormula: colorFormula,
        TextColorFormula: textColorFormula
      },
      {
        Header: ['6 Month','종가'],
        Type: 'Float',
        Name: 'M6',
        Width: '100',
        Format: '#,##0.00',
        Visible: 0,
        UserHidden: 1
      },
      {
        Header: ['6 Month','대비'],
        Type: 'Float',
        Name: 'M6Diff',
        Width: '90',
        Align: 'Right',
        Format:"#,##0.00",
        Formula: diffFormula,
        IconFormula: iconFormula
      },
      {
        Header: ['6 Month','등락율'],
        Type: 'Text',
        Name: 'M6Rate',
        Width: '90',
        Align: 'Right',
        Formula: rateFormula,
        ColorFormula: colorFormula,
        TextColorFormula: textColorFormula
      },
      {
        Header: ['YTD','종가'],
        Type: 'Float',
        Name: 'YTD',
        Width: '100',
        Format: '#,##0.00',
        Visible: 0,
        UserHidden: 1
      },
      {
        Header: ['YTD','대비'],
        Type: 'Float',
        Name: 'YTDDiff',
        Width: '90',
        Align: 'Right',
        Format:"#,##0.00",
        Formula: diffFormula,
        IconFormula: iconFormula
      },
      {
        Header: ['YTD','대비'],
        Type: 'Text',
        Name: 'YTDRate',
        Width: '90',
        Align: 'Right',
        Formula: rateFormula,
        ColorFormula: colorFormula,
        TextColorFormula: textColorFormula
      },
      {
        Header: ['Year','종가'],
        Type: 'Float',
        Name: 'Y1',
        Width: '100',
        Format: '#,##0.00',
        Visible: 0,
        UserHidden: 1
      },
      {
        Header: ['Year','대비'],
        Type: 'Float',
        Name: 'Y1Diff',
        Width: '90',
        Align: 'Right',
        Format:"#,##0.00",
        Formula: diffFormula,
        IconFormula: iconFormula
      },
      {
        Header: ['Year','등락율'],
        Type: 'Text',
        Name: 'Y1Rate',
        Width: '90',
        Align: 'Right',
        Formula: rateFormula,
        ColorFormula: colorFormula,
        TextColorFormula: textColorFormula
      },

      {
        Header: ['52주 최대','일자'],
        Type: 'Date',
        Name: 'TOPDAY52',
        Width: '100',
        DataFormat:"MM/dd/yyyy",
        Format: 'yyyy-MM-dd',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: ['52주 최대','종가'],
        Type: 'Float',
        Name: 'TOPCP52',
        Width: '100',
        Format: '#,##0.00',
        CanEdit: 0
      },
      {
        Header: ['52주 최저','일자'],
        Type: 'Date',
        Name: 'BOTTOMDAY52',
        Width: '100',
        DataFormat:"MM/dd/yyyy",
        Format: 'yyyy-MM-dd',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: ['52주 최저','종가'],
        Type: 'Float',
        Name: 'BOTTOMCP52',
        Width: '100',
        Format: '#,##0.00',
        CanEdit: 0
      },
   
    ],
  },
  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
     "Nation": "한국",
     "IndexName": "KOSPI",
     "CP": 2236.4,
     "D1": 2280.45,
     "W1": 2356.73,
     "M1": 2433.39,
     "M3": 2170.93,
     "M6": 2377.99,
     "YTD": 2988.77,
     "Y1": 2993.29,
     "TOPDAY52": "12\/28\/2021",
     "TOPCP52": 3020.24,
     "BOTTOMDAY52": "09\/30\/2022",
     "BOTTOMCP52": 2155.49
    },
    {
     "Nation": "한국",
     "IndexName": "KOSPI200",
     "CP": 291.1,
     "D1": 297.09,
     "W1": 307.48,
     "M1": 315.58,
     "M3": 282.65,
     "M6": 312.86,
     "YTD": 395.51,
     "Y1": 396.72,
     "TOPDAY52": "12\/28\/2021",
     "TOPCP52": 401.21,
     "BOTTOMDAY52": "09\/30\/2022",
     "BOTTOMCP52": 281.36
    },
    {
     "Nation": "한국",
     "IndexName": "KOSDAQ",
     "CP": 679.29,
     "D1": 692.37,
     "W1": 715.02,
     "M1": 727.54,
     "M3": 675.07,
     "M6": 762.35,
     "YTD": 1037.83,
     "Y1": 1028.05,
     "TOPDAY52": "01\/03\/2022",
     "TOPCP52": 1037.83,
     "BOTTOMDAY52": "10\/13\/2022",
     "BOTTOMCP52": 651.59
    },
    {
     "Nation": "미국",
     "IndexName": "DOW",
     "CP": 33220.8,
     "D1": 32875.71,
     "W1": 33027.49,
     "M1": 33853.52,
     "M3": 29225.61,
     "M6": 30775.43,
     "YTD": 36585.06,
     "Y1": 36488.63,
     "TOPDAY52": "01\/05\/2022",
     "TOPCP52": 369.6552,
     "BOTTOMDAY52": "10\/13\/2022",
     "BOTTOMCP52": 28660.94
    },
    {
     "Nation": "미국",
     "IndexName": "S&P500",
     "CP": 3849.28,
     "D1": 3783.22,
     "W1": 3822.39,
     "M1": 3957.63,
     "M3": 3640.47,
     "M6": 3818.83,
     "YTD": 4796.56,
     "Y1": 4793.06,
     "TOPDAY52": "01\/04\/2022",
     "TOPCP52": 4818.62,
     "BOTTOMDAY52": "10\/13\/2022",
     "BOTTOMCP52": 3491.58
    },
    {
     "Nation": "미국",
     "IndexName": "NASDAQ",
     "CP": 10478.09,
     "D1": 10213.29,
     "W1": 10476.12,
     "M1": 10983.78,
     "M3": 10737.51,
     "M6": 11177.89,
     "YTD": 15832.8,
     "Y1": 15766.22,
     "TOPDAY52": "12\/30\/2021",
     "TOPCP52": 15868.09,
     "BOTTOMDAY52": "10\/13\/2022",
     "BOTTOMCP52": 10088.83
    },
    {
     "Nation": "일본",
     "IndexName": "니케이 225",
     "CP": 26173.81,
     "D1": 26340.50,
     "W1": 26507.87,
     "M1": 28027.84,
     "M3": 26422.05,
     "M6": 26804.60,
     "YTD": 29301.79,
     "Y1": 28906.88,
     "TOPDAY52": "01\/05\/2022",
     "TOPCP52": 26169.14,
     "BOTTOMDAY52": "03\/09\/2022",
     "BOTTOMCP52": 24681.74
    },
    {
     "Nation": "중국",
     "IndexName": "상해종합",
     "CP": 3073.7,
     "D1": 3087.4,
     "W1": 3054.43,
     "M1": 3149.75,
     "M3": 3041.21,
     "M6": 3361.52,
     "YTD": 3632.33,
     "Y1": 3597,
     "TOPDAY52": "01\/04\/2022",
     "TOPCP52": 3651.89,
     "BOTTOMDAY52": "04\/27\/2022",
     "BOTTOMCP52": 2863.65
    },
    {
     "Nation": "홍콩",
     "IndexName": "항생",
     "CP": 19741.14,
     "D1": 19898.91,
     "W1": 19679.22,
     "M1": 18204.68,
     "M3": 17165.87,
     "M6": 21996.89,
     "YTD": 23274.75,
     "Y1": 23086.54,
     "TOPDAY52": "02\/10\/2022",
     "TOPCP52": 25050.59,
     "BOTTOMDAY52": "10\/31\/2022",
     "BOTTOMCP52": 14597.31
    },
    {
     "Nation": "러시아",
     "IndexName": "RTS",
     "CP": 936.8,
     "D1": 933.76,
     "W1": 969.7,
     "M1": 1128.71,
     "M3": 1072.26,
     "M6": 1413.01,
     "YTD": 1622.75,
     "Y1": 1589.74,
     "TOPDAY52": "01\/03\/2022",
     "TOPCP52": 1640.39,
     "BOTTOMDAY52": "02\/24\/2022",
     "BOTTOMCP52": 610.33
    },
    {
     "Nation": "독일",
     "IndexName": "DAX",
     "CP": 14071.72,
     "D1": 13925.6,
     "W1": 13914.07,
     "M1": 14355.45,
     "M3": 11975.55,
     "M6": 13003.35,
     "YTD": 16020.73,
     "Y1": 158.2552,
     "TOPDAY52": "01\/05\/2022",
     "TOPCP52": 16285.35,
     "BOTTOMDAY52": "09\/28\/2022",
     "BOTTOMCP52": 11862.84
    },
    {
     "Nation": "유럽",
     "IndexName": "EuroSTOXX50",
     "CP": 3850.07,
     "D1": 3808.82,
     "W1": 3823.29,
     "M1": 3934.44,
     "M3": 3279.04,
     "M6": 3514.32,
     "YTD": 4331.82,
     "Y1": 4284.83,
     "TOPDAY52": "01\/05\/2022",
     "TOPCP52": 4395.78,
     "BOTTOMDAY52": "09\/29\/2022",
     "BOTTOMCP52": 3249.57
    },
    {
     "Nation": "인도",
     "IndexName": "SENSEX",
     "CP": 61133.88,
     "D1": 60910.28,
     "W1": 60826.22,
     "M1": 62681.84,
     "M3": 56409.96,
     "M6": 53026.97,
     "YTD": 59183.22,
     "Y1": 57806.49,
     "TOPDAY52": "12\/01\/2022",
     "TOPCP52": 63583.07,
     "BOTTOMDAY52": "06\/17\/2022",
     "BOTTOMCP52": 50921.22
    }
   ]
};

function diffFormula(fr) { 
  // 금일 종가 대비 값을 계산하여 리턴
  const baseCol = fr.Col.substring(0, fr.Col.length-4);
  return fr.Sheet.getValue(fr.Row, "CP") - fr.Sheet.getValue(fr.Row, baseCol);
}

function iconFormula(fr) {
  const v = fr.Sheet.getValue(fr.Row, fr.Col);
  return v>0?"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABIAAAASCAYAAAEhyb7BAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKT2lDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVNnVFPpFj333vRCS4iAlEtvUhUIIFJCi4AUkSYqIQkQSoghodkVUcERRUUEG8igiAOOjoCMFVEsDIoK2AfkIaKOg6OIisr74Xuja9a89+bN/rXXPues852zzwfACAyWSDNRNYAMqUIeEeCDx8TG4eQuQIEKJHAAEAizZCFz/SMBAPh+PDwrIsAHvgABeNMLCADATZvAMByH/w/qQplcAYCEAcB0kThLCIAUAEB6jkKmAEBGAYCdmCZTAKAEAGDLY2LjAFAtAGAnf+bTAICd+Jl7AQBblCEVAaCRACATZYhEAGg7AKzPVopFAFgwABRmS8Q5ANgtADBJV2ZIALC3AMDOEAuyAAgMADBRiIUpAAR7AGDIIyN4AISZABRG8lc88SuuEOcqAAB4mbI8uSQ5RYFbCC1xB1dXLh4ozkkXKxQ2YQJhmkAuwnmZGTKBNA/g88wAAKCRFRHgg/P9eM4Ors7ONo62Dl8t6r8G/yJiYuP+5c+rcEAAAOF0ftH+LC+zGoA7BoBt/qIl7gRoXgugdfeLZrIPQLUAoOnaV/Nw+H48PEWhkLnZ2eXk5NhKxEJbYcpXff5nwl/AV/1s+X48/Pf14L7iJIEyXYFHBPjgwsz0TKUcz5IJhGLc5o9H/LcL//wd0yLESWK5WCoU41EScY5EmozzMqUiiUKSKcUl0v9k4t8s+wM+3zUAsGo+AXuRLahdYwP2SycQWHTA4vcAAPK7b8HUKAgDgGiD4c93/+8//UegJQCAZkmScQAAXkQkLlTKsz/HCAAARKCBKrBBG/TBGCzABhzBBdzBC/xgNoRCJMTCQhBCCmSAHHJgKayCQiiGzbAdKmAv1EAdNMBRaIaTcA4uwlW4Dj1wD/phCJ7BKLyBCQRByAgTYSHaiAFiilgjjggXmYX4IcFIBBKLJCDJiBRRIkuRNUgxUopUIFVIHfI9cgI5h1xGupE7yAAygvyGvEcxlIGyUT3UDLVDuag3GoRGogvQZHQxmo8WoJvQcrQaPYw2oefQq2gP2o8+Q8cwwOgYBzPEbDAuxsNCsTgsCZNjy7EirAyrxhqwVqwDu4n1Y8+xdwQSgUXACTYEd0IgYR5BSFhMWE7YSKggHCQ0EdoJNwkDhFHCJyKTqEu0JroR+cQYYjIxh1hILCPWEo8TLxB7iEPENyQSiUMyJ7mQAkmxpFTSEtJG0m5SI+ksqZs0SBojk8naZGuyBzmULCAryIXkneTD5DPkG+Qh8lsKnWJAcaT4U+IoUspqShnlEOU05QZlmDJBVaOaUt2ooVQRNY9aQq2htlKvUYeoEzR1mjnNgxZJS6WtopXTGmgXaPdpr+h0uhHdlR5Ol9BX0svpR+iX6AP0dwwNhhWDx4hnKBmbGAcYZxl3GK+YTKYZ04sZx1QwNzHrmOeZD5lvVVgqtip8FZHKCpVKlSaVGyovVKmqpqreqgtV81XLVI+pXlN9rkZVM1PjqQnUlqtVqp1Q61MbU2epO6iHqmeob1Q/pH5Z/YkGWcNMw09DpFGgsV/jvMYgC2MZs3gsIWsNq4Z1gTXEJrHN2Xx2KruY/R27iz2qqaE5QzNKM1ezUvOUZj8H45hx+Jx0TgnnKKeX836K3hTvKeIpG6Y0TLkxZVxrqpaXllirSKtRq0frvTau7aedpr1Fu1n7gQ5Bx0onXCdHZ4/OBZ3nU9lT3acKpxZNPTr1ri6qa6UbobtEd79up+6Ynr5egJ5Mb6feeb3n+hx9L/1U/W36p/VHDFgGswwkBtsMzhg8xTVxbzwdL8fb8VFDXcNAQ6VhlWGX4YSRudE8o9VGjUYPjGnGXOMk423GbcajJgYmISZLTepN7ppSTbmmKaY7TDtMx83MzaLN1pk1mz0x1zLnm+eb15vft2BaeFostqi2uGVJsuRaplnutrxuhVo5WaVYVVpds0atna0l1rutu6cRp7lOk06rntZnw7Dxtsm2qbcZsOXYBtuutm22fWFnYhdnt8Wuw+6TvZN9un2N/T0HDYfZDqsdWh1+c7RyFDpWOt6azpzuP33F9JbpL2dYzxDP2DPjthPLKcRpnVOb00dnF2e5c4PziIuJS4LLLpc+Lpsbxt3IveRKdPVxXeF60vWdm7Obwu2o26/uNu5p7ofcn8w0nymeWTNz0MPIQ+BR5dE/C5+VMGvfrH5PQ0+BZ7XnIy9jL5FXrdewt6V3qvdh7xc+9j5yn+M+4zw33jLeWV/MN8C3yLfLT8Nvnl+F30N/I/9k/3r/0QCngCUBZwOJgUGBWwL7+Hp8Ib+OPzrbZfay2e1BjKC5QRVBj4KtguXBrSFoyOyQrSH355jOkc5pDoVQfujW0Adh5mGLw34MJ4WHhVeGP45wiFga0TGXNXfR3ENz30T6RJZE3ptnMU85ry1KNSo+qi5qPNo3ujS6P8YuZlnM1VidWElsSxw5LiquNm5svt/87fOH4p3iC+N7F5gvyF1weaHOwvSFpxapLhIsOpZATIhOOJTwQRAqqBaMJfITdyWOCnnCHcJnIi/RNtGI2ENcKh5O8kgqTXqS7JG8NXkkxTOlLOW5hCepkLxMDUzdmzqeFpp2IG0yPTq9MYOSkZBxQqohTZO2Z+pn5mZ2y6xlhbL+xW6Lty8elQfJa7OQrAVZLQq2QqboVFoo1yoHsmdlV2a/zYnKOZarnivN7cyzytuQN5zvn//tEsIS4ZK2pYZLVy0dWOa9rGo5sjxxedsK4xUFK4ZWBqw8uIq2Km3VT6vtV5eufr0mek1rgV7ByoLBtQFr6wtVCuWFfevc1+1dT1gvWd+1YfqGnRs+FYmKrhTbF5cVf9go3HjlG4dvyr+Z3JS0qavEuWTPZtJm6ebeLZ5bDpaql+aXDm4N2dq0Dd9WtO319kXbL5fNKNu7g7ZDuaO/PLi8ZafJzs07P1SkVPRU+lQ27tLdtWHX+G7R7ht7vPY07NXbW7z3/T7JvttVAVVN1WbVZftJ+7P3P66Jqun4lvttXa1ObXHtxwPSA/0HIw6217nU1R3SPVRSj9Yr60cOxx++/p3vdy0NNg1VjZzG4iNwRHnk6fcJ3/ceDTradox7rOEH0x92HWcdL2pCmvKaRptTmvtbYlu6T8w+0dbq3nr8R9sfD5w0PFl5SvNUyWna6YLTk2fyz4ydlZ19fi753GDborZ752PO32oPb++6EHTh0kX/i+c7vDvOXPK4dPKy2+UTV7hXmq86X23qdOo8/pPTT8e7nLuarrlca7nuer21e2b36RueN87d9L158Rb/1tWeOT3dvfN6b/fF9/XfFt1+cif9zsu72Xcn7q28T7xf9EDtQdlD3YfVP1v+3Njv3H9qwHeg89HcR/cGhYPP/pH1jw9DBY+Zj8uGDYbrnjg+OTniP3L96fynQ89kzyaeF/6i/suuFxYvfvjV69fO0ZjRoZfyl5O/bXyl/erA6xmv28bCxh6+yXgzMV70VvvtwXfcdx3vo98PT+R8IH8o/2j5sfVT0Kf7kxmTk/8EA5jz/GMzLdsAAAAEZ0FNQQAAsY58+1GTAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAFSSURBVHjaYvz//z8DDDD+t7RkYGBg+M/AwMDIiCwDAAAA//+Ccxj/W1r+RxEBAAAA//+CaWL4z8j4j/HoUSYGKysGxn9WVv8Y//9nZEACAAAAAP//QjERosXSkuH///8M/21smP5bWkINtbKCKGNmZoRbh9MMAAAAAP//wjQUC4C7keHYMYb/1tYIp3FzMzF8/YrkI5jlOAwiyjoAAAAA//8iRpE4iQ6HAKb/jIx/YIEMF0TWwMDA8Jfx/39GBiur/wzHjmFxEzYfHjvGyGBlRTAIfjIwMHBgxAk6+M/I+JMo3zExEAEAAAAA//+sk7sOgDAIRY/aqR30e/j2znyPg5OJj8HGalK1JjDC5YRcoIpUB7p7+ahDdUtOFQWumFUFkR4Yz5wIhNCkWtaVzjI1BGB6nc97R4zLdboDlCF/DeuAFdWqH/iKGRjMttZiFGagfQDmWI4mO/mFrgAAAABJRU5ErkJggg==":
        v<0?"data:image/png;base64,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":"";
}


function rateFormula(fr) { 
  // 금일 종가 대비 값을 계산하여 리턴
  const baseCol = fr.Col.substring(0, fr.Col.length-4);
  const diff = parseFloat((fr.Sheet.getValue(fr.Row, "CP") - fr.Sheet.getValue(fr.Row, baseCol)).toFixed(2));
  const rate =   Math.abs(parseInt((diff/(fr.Sheet.getValue(fr.Row, "CP")/100))*100)/100);
  return (diff>0?"+":diff<0?"-":"")+rate+" %";
}




var __blue = ["#f5f7ff","#e3e7fc","#d4dbff","#c0cafc","#0d35fc"];
var __red = ["#fcedef","#ffe3e6","#fccfd4","#fcc0c6","#fc0820"];

function colorFormula(fr) {
  const v = fr.Sheet.getValue(fr.Row, fr.Col);
 
  const rate =  parseFloat( (v.charAt(0)=="-"?"-":"") +  v.substring( v.indexOf("(")).replace(/[^0-9\.]/g,""));
  if(rate>0){
    if(rate>10){
      return __red[3];
    }else if(rate>7){
      return __red[2];
    }else if(rate>3){
      return __red[1];
    }else{
      return __red[0];
    }
  }else if(rate<0){
    if(rate<-10){
      return __blue[3];
    }else if(rate<-7){
      return __blue[2];
    }else if(rate<-3){
      return __blue[1];
    }else{
      return __blue[0];
    }
  }
  return "#FFFFFF";
}

function textColorFormula(fr) {
  const v = fr.Sheet.getValue(fr.Row, fr.Col);

  if(v.indexOf("-")>-1) return __blue[4];
  else if(parseInt(v.replace(/[^\d]/g,""))===0) return ""; 

  return __red[4];
}